//////////////////////////////////////////////
// WebUnitTests_pre.js
//
// Preloading script for Electron based
// runs.
//////////////////////////////////////////////

/// Imports ----------------------------------

const {contextBridge, ipcRenderer} = require("electron") ;

contextBridge.exposeInMainWorld("nkWeb",
{
	isCi : () => {return ipcRenderer.invoke("nk:isCi")},
	listTestFiles : () => {return ipcRenderer.invoke("nk:listTestFiles")},
	readFile : (path, content) => {return ipcRenderer.invoke("nk:readFile", path)},
	writeFile : (path, content) => {return ipcRenderer.invoke("nk:writeFile", path, content)},
	forwardException : (message) => {return ipcRenderer.invoke("nk:forwardException", message)},
	closeApp : () => {ipcRenderer.invoke("nk:closeApp")}
}) ;